import { createApp } from 'vue'
import App from './App.vue'
import router from './router'
import ElementPlus from 'element-plus'
import * as ElementPlusIconsVue from '@element-plus/icons-vue'

import 'element-plus/dist/index.css'
import locale from 'element-plus/dist/locale/ro.mjs'

import dayjs from 'dayjs'

// set first day of week to Monday
dayjs.Ls.en.weekStart = 1
dayjs.Ls.de ??= {}
dayjs.Ls.de.weekStart = 1

import 'bootstrap/dist/css/bootstrap.css'
import 'bootstrap-vue-next/dist/bootstrap-vue-next.css'


import VueSweetalert2 from 'vue-sweetalert2';
import 'sweetalert2/dist/sweetalert2.min.css';
// Vue.use(VueSweetalert2);
import moment from 'moment';

const app = createApp(App)
app.use(router)
app.use(VueSweetalert2);
app.use(ElementPlus, { locale })
for (const [key, component] of Object.entries(ElementPlusIconsVue)) {
    app.component(key, component);
}
app.config.globalProperties.$DataOraFaraSec = function(value) {
    if(!value) return "-";
    return moment(value).format("DD.MM.YYYY HH:mm");
};

app.config.globalProperties.$DataRo = function(value) {
    if(!value) return "-";
    return moment(value).format("DD.MM.YYYY");
};
// app.config.globalProperties.$Luna = function(value) {
//     if(!value) return "-";
//     return moment(value).format("MM");
// };
app.mount('#app')