import axios from 'axios';
import { useRouter } from 'vue-router';
import moment from "moment";

export default {
  version: "1.0",
  BASE_URL: "https://breakingpoint-nou.brk-dev.ro/api/index.php/",
  BASE_URL_NO_INDEX: "",

  set_token: function (nume, email = '', token = '', defaultLang = '') {
    window.localStorage.setItem("breakingpoint-token", token);
    window.localStorage.setItem("breakingpoint-nume", nume);
    window.localStorage.setItem("breakingpoint-email", email);
    axios.defaults.headers.common = {
      "Token": token
    };
  },

  get_nume: function () {
    return window.localStorage.getItem("breakingpoint-nume");
  },

  get_email: function () {
    return window.localStorage.getItem("breakingpoint-email");
  },

  get_token: function () {
    return window.localStorage.getItem("breakingpoint-token");
  },

  get_user: async function () {
    const url = this.BASE_URL + '/UserInformation/get_user'
    try {
      const utilizator = await axios.post(url, { token: this.get_token() });
      return utilizator
    } catch (error) {
      console.error(error);
      return;
    }
  },

  // is_logged_in: function () {
  //     var token = this.get_token();
  //     return token !== "";
  // },

  logout: function () {
    this.set_token('');
  },

  is_logged(body = {}, vueInstance) {
    if (body.NotLogged) {
      this.logout();
      this.verify_login_and_redirect(vueInstance)
      if (body.MesajEroare) {
        vueInstance.$swal.fire({
          title: 'Eroare',
          text: body.Mesaage,
          icon: 'error',
          confirmButtonText: 'Ok'
        })
      }
    }
  },

  is_logged_in: function (body = {}) {

    var token = this.get_token();

    var is_logged = token !== "" && token !== null && token.length > 0;
    // is_logged = token != null;
    // is_logged = token.length > 0;

    return is_logged;
  },

  verify_response: function (response) {
    if (response.NotLogged) {
      return false;
    }
    return true;
  },

  redirect_to_homepage(vueInstance) {
    vueInstance.$router.push("/");
  },

  verify_login_and_redirect: function (vueInstance) {

    if (!this.is_logged_in()) {

      this.redirect_to_homepage(vueInstance);
    }
  },

  datePickerOptions: {

    shortcuts: [
      {
        text: 'Astazi',
        value: [new Date(), new Date()],
      },
      {
        text: 'Ieri',
        value: () => {
          const end = new Date();
          const start = new Date();
          start.setDate(start.getDate() - 1);
          return [start, end];
        },
      },
      {
        text: 'Ultima saptamana',
        value: () => {
          const end = new Date();
          const start = new Date();
          start.setDate(start.getDate() - 7);
          return [start, end];
        },
      },
      {
        text: 'Luna curenta',
        value: [new Date(), new Date()],
      },
      {
        text: 'Luna trecuta',
        value: () => {
          const end = new Date();
          const start = new Date();
          start.setMonth(start.getMonth() - 1);
          return [start, end];
        },
      },
      {
        text: 'Anul curent',
        value: () => {
          const end = new Date();
          const start = new Date(new Date().getFullYear(), 0);
          return [start, end];
        },
      },
      {
        text: 'Anul trecut',
        value: () => {
          const end = new Date();
          const start = new Date();
          start.setFullYear(start.getFullYear() - 1);
          return [start, end];
        },
      },
      {
        text: 'Ultimele 6 luni',
        value: () => {
          const end = new Date();
          const start = new Date();
          start.setMonth(start.getMonth() - 6);
          return [start, end];
        },
      },
      {
        text: 'Tot timpul',
        value: () => {
          const end = new Date();
          const start = new Date(2000, 0, 1);
          return [start, end];
        },
      },
    ],
  },
};
