<?php

namespace App\Controllers;

use ApiResponse;
use App\Controllers\BaseController;
use CodeIgniter\Database\BaseConnection;
use PaginationInfo;
use stdClass;
use TableSql;

class Utilizatori extends BaseController
{

    public function index()
    {
        $ret            = $this->verify_login();
        if(!$ret->NotLogged)
        {
            $filters      = $this->request->getPost("Filters");
            $order_by     = $this->request->getPost("OrderBy");
            $pg_info      = new PaginationInfo($this->request->getPost("PaginationInfo") );


            $sql          = new TableSql( "SELECT t1.* FROM utilizatori t1 WHERE 1=1  " );


            $sql->addIfNeeded( $filters['Nume'], '', " AND t1.Nume LIKE '%%%s%%' ");
            $sql->addIfNeeded( $filters['Email'], '', " AND t1.Email LIKE '%%%s%%' ");



            $sql->addLimitFromPagination($pg_info);


            $result = $sql->getResult();
            $rows   = $result->Rows;
            //
            $pg_info->RowCount = $result->FullRowsCount;
            //
            $ret->Results        = $rows;
            $ret->PaginationInfo = $pg_info;
        }

        echo json_encode($ret);
    }

    public function get_info()
    {
        $ret            = $this->verify_login();
        if(!$ret->NotLogged)
        {



        }

        echo json_encode($ret);
    }


    public function get_info_for_dialog()
    {
        $ret            = $this->verify_login();
        if(!$ret->NotLogged)
        {


        }

        echo json_encode($ret);
    }

    public function get_info_item_dialog()
    {
        $ret            = $this->verify_login();
        if(!$ret->NotLogged)
        {
            $id                  = $this->request->getPost("id");
            $ret->Item = $this->db->table("utilizatori")->where("Id", $id)->get()->getFirstRow();
        }

        echo json_encode($ret);
    }

    public function save()
    {
        $ret = $this->verify_login();

        if (!$ret->NotLogged) {
            $mode = $this->request->getPost("mode");
            $item = $this->request->getPost("object");

            if ($mode == "add") {
                if (array_key_exists('Id', $item)){
                    unset($item['Id']);
                }
                $item['Parola'] = md5($item['Parola']);
                $this->db->table("utilizatori")->insert($item);
                $id = $this->db->insertID();
            } else {
                $id = $item['Id'];
                unset($item['Id']);
                unset($item['Parola']);
                $this->db->table("utilizatori")->where("Id", $id)->update($item);
            }
        }

        return $this->response->setJSON($ret);
    }

    public function change_password()
    {
        $ret            = $this->verify_login();

        if(!$ret->NotLogged)
        {
            $info = $this->request->getPost( "info" );
            $user = $this->getUserDetails();
            $old_password  = $info['OldPassword' ];
            $new_password  = $info['NewPassword' ];
            $new_password2 = $info['NewPassword2'];

            $old_password_md5  = md5($old_password);

           
            if( strtolower( $old_password_md5 ) != strtolower( $user->Parola ))
            {
                $ret->HasError = true;
                $ret->Error   = 'Parola veche este incorecta!';
            }
            else if( $new_password != $new_password2 )
            {
                $ret->HasError = true;
                $ret->Error   = 'Parola noua nu este introdus corect!';
            }
            else
            {
                $ret->HasError  = false;
                $user->Parola   = md5($new_password);
                $this->db->table('utilizatori')->where('Id', $user->Id)->update(['Parola' => md5($new_password)]);
            }
        }
        return $this->response->setJSON($ret);
        
     
    }

    public function delete_item()
    {
        $ret            = $this->verify_login();

        if(!$ret->NotLogged)
        {
            $id = $this->request->getPost("id");
            $this->db->table("utilizatori")->where("id", $id)->set("Sters", "1")->update();
        }

        echo  json_encode($ret);
    }

}
