<?php

namespace App\Controllers;

use ApiResponse;
use App\Controllers\BaseController;
use CodeIgniter\Database\BaseConnection;
use PaginationInfo;
use stdClass;
use TableSql;

class Echipa extends BaseController
{
    public function index() {
        $ret            = $this->verify_login();
        if(!$ret->NotLogged)
        {
            $filters      = $this->request->getPost("Filters");
            $order_by     = $this->request->getPost("OrderBy");
            $pg_info      = new PaginationInfo($this->request->getPost("PaginationInfo") );


            $sql          = new TableSql( "SELECT t1.* FROM echipa t1 WHERE Sters = 0  " );


            $sql->addIfNeeded( $filters['Nume'], '', " AND t1.Nume LIKE '%%%s%%' ");

            $sql->addLimitFromPagination($pg_info);


            $result = $sql->getResult();
            $rows   = $result->Rows;
            //
            $pg_info->RowCount = $result->FullRowsCount;
            //
            $ret->Results        = $rows;
            $ret->PaginationInfo = $pg_info;
        }

        echo json_encode($ret);
    }

    public function get_info() {
        $ret            = $this->verify_login();
        if(!$ret->NotLogged)
        {



        }

        echo json_encode($ret);
    }


    public function get_info_for_dialog() {
        $ret            = $this->verify_login();
        if(!$ret->NotLogged)
        {


        }

        echo json_encode($ret);
    }

    public function get_info_item_dialog() {
        $ret            = $this->verify_login();
        if(!$ret->NotLogged)
        {
            $Id                  = $this->request->getPost("Id");
            $ret->Item = $this->db->table("echipa")->where("Id", $Id)->get()->getFirstRow();
        }

        echo json_encode($ret);
    }

    public function save() {
        $ret = $this->verify_login();

        if (!$ret->NotLogged) {
            $mode = $this->request->getPost("mode");
            $item = $this->request->getPost("object");

            if ($mode == "add") {
                if (array_key_exists('Id', $item)){
                    unset($item['Id']);
                }
                $this->db->table("echipa")->insert($item);
                $Id = $this->db->insertID();
            } else {
                $Id = $item['Id'];
                unset($item['Id']);
                $this->db->table("echipa")->where("Id", $Id)->update($item);
            }
        }

        return $this->response->setJSON($ret);
    }

    public function delete_item() {
        $ret            = $this->verify_login();

        if(!$ret->NotLogged)
        {
            $id = $this->request->getPost("id");
            $this->db->table("echipa")->where("id", $id)->set("Sters", "1")->update();
        }

        echo  json_encode($ret);
    }

    public function upload() {

        $ret            = $this->verify_login();

        if(!$ret->NotLogged)
        {
            $this->load->helper('upload_info');
            $uh         = new UploadHelper();
            if (!is_dir('./assets')) mkdir('./assets');
            if (!is_dir('./assets/imagini')) mkdir('./assets/imagini');
            $uh->upload('./assets/imagini', 'file', 'jpg|png|jpeg|gif');
            if ($uh->HasError) {
                die($uh->Error);
            } else {
                echo json_encode($uh);
            }
        }

        echo  json_encode($ret);
    }
}
